IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[P_EST_TOP_SHOW]') AND type in (N'P', N'PC'))
begin
	DROP PROCEDURE P_EST_TOP_SHOW
end
GO
CREATE PROCEDURE P_EST_TOP_SHOW (@CD_EMP INT =1,@CD_TOP_SHOW INT, @CD_USU INT=1)
AS
SET NOCOUNT ON;
DECLARE @HOJE DATETIME = CONVERT(DATE,GETDATE());

/*********************************************************************************************************************/
PRINT 'Carregando os produtos do Top Show - Time ' + convert(varchar,getdate(),108)
/*********************************************************************************************************************/ 
-- Produtos
/*********************************************************************************************************************/

	SELECT 
		S.CD_EMP,
		S.CD_TOP_SHOW,	
		s.DT_INI_TOP_SHOW,
		s.DT_FIM_TOP_SHOW,
		DATEADD(YEAR,-1,s.DT_INI_TOP_SHOW) DT_INI_ANO,
		DATEADD(YEAR,-1,s.DT_FIM_TOP_SHOW) DT_FIM_ANO,
		DATEADD(DAY,-120,s.DT_INI_TOP_SHOW) DT_INI_ULT,
		DATEADD(DAY,-120,s.DT_FIM_TOP_SHOW)	DT_FIM_ULT,  
		F.CD_FILIAL,
		P.CD_PROD,
		P.PERC_CRESC
		INTO #RS_TOP_PROD
	FROM
		EST_TOP_SHOW S
		INNER JOIN EST_TOP_SHOW_PRC_FILIAL F ON 
		S.CD_EMP	  = F.CD_EMP AND
		S.CD_TOP_SHOW = F.CD_TOP_SHOW
		INNER JOIN EST_TOP_SHOW_EST_PROD P ON 
		S.CD_EMP	  = P.CD_EMP AND
		S.CD_TOP_SHOW = P.CD_TOP_SHOW
	WHERE 
		S.CD_EMP=@CD_EMP 
		AND S.CD_TOP_SHOW =@CD_TOP_SHOW
		AND s.DT_INI_TOP_SHOW <= @HOJE		
		AND s.DT_FIM_TOP_SHOW >= @HOJE;
	/*	 
	DELETE FROM B FROM
		EST_TOP_SHOW_EST_PROD_PRC_FILIAL A
		INNER JOIN #RS_TOP_PROD B ON 
		A.CD_EMP = B.CD_EMP AND
		A.CD_FILIAL=B.CD_FILIAL AND
		A.CD_PROD=B.CD_PROD
	WHERE
		A.CD_TOP_SHOW=@CD_TOP_SHOW
	*/
	DELETE FROM EST_TOP_SHOW_EST_PROD_PRC_FILIAL WHERE CD_EMP=@CD_EMP AND CD_TOP_SHOW=@CD_TOP_SHOW
	
	---------------------------------------------------------------------------
	SELECT  
		P.CD_EMP,
		P.CD_FILIAL,
		P.CD_PROD,
		SUM(I.QT_IT) QTDE
		INTO #RS_TOP_PROD_ANO
	FROM
		V_PDV_VD_IT I
		INNER JOIN #RS_TOP_PROD P ON
		I.CD_EMP  = P.CD_EMP AND
		I.CD_FILIAL  = P.CD_FILIAL AND
		I.CD_PROD  = P.CD_PROD
		AND I.DT_VD BETWEEN P.DT_INI_ANO AND P.DT_FIM_ANO 
	WHERE
		I.CD_EMP = @CD_EMP
	GROUP BY 	P.CD_EMP,
		P.CD_FILIAL,
		P.CD_PROD

	SELECT  
		P.CD_EMP,
		P.CD_FILIAL,
		P.CD_PROD,
		SUM(I.QT_IT) QTDE
		INTO #RS_TOP_PROD_ULT
	FROM
		V_PDV_VD_IT I
		INNER JOIN #RS_TOP_PROD P ON
		I.CD_EMP  = P.CD_EMP AND
		I.CD_FILIAL  = P.CD_FILIAL AND
		I.CD_PROD  = P.CD_PROD
		AND I.DT_VD BETWEEN P.DT_INI_ULT AND P.DT_FIM_ULT 
	WHERE
		I.CD_EMP = @CD_EMP
	GROUP BY 	
		P.CD_EMP,
		P.CD_FILIAL,
		P.CD_PROD; 
	---------------------------------------------------------------------------
	INSERT INTO EST_TOP_SHOW_EST_PROD_PRC_FILIAL(CD_EMP,CD_TOP_SHOW,CD_FILIAL,CD_PROD,
													DT_INI_REF,DT_FIM_REF,PERC_META,QTDE_META,CD_USU,DT_CAD,QTDE_VD_ANO,QTDE_VD_ULT)
	SELECT 
		P.CD_EMP,
		CD_TOP_SHOW,
		P.CD_FILIAL,
		P.CD_PROD,
		CASE WHEN ISNULL(A.QTDE,0) > ISNULL(U.QTDE,0) THEN
				P.DT_INI_ANO
			ELSE P.DT_INI_ULT END DT_INI_REF,

		CASE WHEN ISNULL(A.QTDE,0) > ISNULL(U.QTDE,0) THEN
				P.DT_FIM_ANO
			ELSE P.DT_FIM_ULT END DT_FIM_REF, 
		P.PERC_CRESC, 
		ROUND(CASE WHEN ISNULL(A.QTDE,0) > ISNULL(U.QTDE,0) THEN ISNULL(A.QTDE,0)
				ELSE  ISNULL(U.QTDE,0)END  * (1+(P.PERC_CRESC/100.00)),0) META,
		@CD_USU,
		GETDATE(),
		ISNULL(A.QTDE,0) QTDE_VD_ANO,
		ISNULL(U.QTDE,0) QTDE_VD_ULT
	FROM 
		#RS_TOP_PROD P
		LEFT JOIN #RS_TOP_PROD_ANO A ON 
		P.CD_EMP = A.CD_EMP AND
		P.CD_PROD = A.CD_PROD AND
		P.CD_FILIAL = A.CD_FILIAL
		LEFT JOIN #RS_TOP_PROD_ULT U ON 
		P.CD_EMP = U.CD_EMP AND
		P.CD_PROD = U.CD_PROD AND
		P.CD_FILIAL = U.CD_FILIAL;
	
	--DELETE FROM EST_TOP_SHOW_EST_PROD_PRC_FILIAL WHERE QTDE_META =0;
	DROP TABLE #RS_TOP_PROD
	DROP TABLE #RS_TOP_PROD_ANO
	DROP TABLE #RS_TOP_PROD_ULT

	
	UPDATE A
	SET QTD_VD=META
	FROM
		EST_TOP_SHOW_EST_PROD  A
		INNER JOIN (SELECT 
						CD_EMP,	
						CD_TOP_SHOW	,
						CD_PROD,	
						SUM(QTDE_META) META
					FROM 
						EST_TOP_SHOW_EST_PROD_PRC_FILIAL
					WHERE
						CD_TOP_SHOW=@CD_TOP_SHOW
					GROUP BY 
					CD_EMP,	
						CD_TOP_SHOW	,
						CD_PROD) CONS ON
		A.CD_EMP = CONS.CD_EMP AND
		A.CD_TOP_SHOW = CONS.CD_TOP_SHOW	 AND
		A.CD_PROD =CONS.CD_PROD	
	WHERE
		A.CD_TOP_SHOW=@CD_TOP_SHOW
		AND A.CD_EMP=@CD_EMP

/*********************************************************************************************************************/
	PRINT 'Carregando os fabricantes do Top Show - Time ' + convert(varchar,getdate(),108)
/*********************************************************************************************************************/
-- Fabricantes
/*********************************************************************************************************************/

	SELECT 
		S.CD_EMP,
		S.CD_TOP_SHOW,	
		s.DT_INI_TOP_SHOW,
		s.DT_FIM_TOP_SHOW,
		DATEADD(YEAR,-1,s.DT_INI_TOP_SHOW) DT_INI_ANO,
		DATEADD(YEAR,-1,s.DT_FIM_TOP_SHOW) DT_FIM_ANO,
		DATEADD(DAY,-120,s.DT_INI_TOP_SHOW) DT_INI_ULT,
		DATEADD(DAY,-120,s.DT_FIM_TOP_SHOW)	DT_FIM_ULT,  
		F.CD_FILIAL,
		P.CD_FABRIC ,
		P.PERC_CRESC
		INTO #RS_TOP_FABRIC
	FROM
		EST_TOP_SHOW S
		INNER JOIN EST_TOP_SHOW_PRC_FILIAL F ON 
		S.CD_EMP	  = F.CD_EMP AND
		S.CD_TOP_SHOW = F.CD_TOP_SHOW
		INNER JOIN EST_TOP_SHOW_EST_PROD_FABRIC P ON 
		S.CD_EMP	  = P.CD_EMP AND
		S.CD_TOP_SHOW = P.CD_TOP_SHOW 
	WHERE 
		S.CD_EMP=@CD_EMP 
		AND S.CD_TOP_SHOW =@CD_TOP_SHOW
		AND s.DT_INI_TOP_SHOW <= @HOJE		
		AND s.DT_FIM_TOP_SHOW >= @HOJE;

	/*
	DELETE FROM B FROM
		EST_TOP_SHOW_EST_PROD_FABRIC_PRC_FILIAL A
		INNER JOIN #RS_TOP_FABRIC B ON 
		A.CD_EMP = B.CD_EMP AND
		A.CD_FILIAL=B.CD_FILIAL AND
		A.CD_FABRIC=B.CD_FABRIC
	WHERE
		A.CD_TOP_SHOW=@CD_TOP_SHOW
	*/
	DELETE FROM EST_TOP_SHOW_EST_PROD_FABRIC_PRC_FILIAL WHERE CD_EMP=@CD_EMP AND CD_TOP_SHOW=@CD_TOP_SHOW
	--------------------------------------------------------------------------------------
	SELECT  
		F.CD_EMP,
		F.CD_FILIAL,
		F.CD_FABRIC,
		SUM(I.QT_IT) QTDE
		INTO #RS_TOP_FABRIC_ANO
	FROM
		V_PDV_VD_IT I 
		INNER JOIN EST_PROD P ON
		I.CD_EMP	 = P.CD_EMP AND
		I.CD_PROD    = P.CD_PROD
		INNER JOIN #RS_TOP_FABRIC F ON
		I.CD_EMP	 = F.CD_EMP AND
		I.CD_FILIAL  = F.CD_FILIAL AND
		P.CD_FABRIC  = F.CD_FABRIC
		AND I.DT_VD BETWEEN F.DT_INI_ANO AND F.DT_FIM_ANO 
	WHERE
		I.CD_EMP = @CD_EMP
	GROUP BY 		
		F.CD_EMP,
		F.CD_FILIAL,
		F.CD_FABRIC;

	SELECT  
		F.CD_EMP,
		F.CD_FILIAL,
		F.CD_FABRIC,
		SUM(I.QT_IT) QTDE
		INTO #RS_TOP_FABRIC_ULT
	FROM
		V_PDV_VD_IT I 
		INNER JOIN EST_PROD P ON
		I.CD_EMP	 = P.CD_EMP AND
		I.CD_PROD    = P.CD_PROD
		INNER JOIN #RS_TOP_FABRIC F ON
		I.CD_EMP	 = F.CD_EMP AND
		I.CD_FILIAL  = F.CD_FILIAL AND
		P.CD_FABRIC  = F.CD_FABRIC
		AND I.DT_VD BETWEEN F.DT_INI_ULT AND F.DT_FIM_ULT 
	WHERE
		I.CD_EMP = @CD_EMP
	GROUP BY 	
		F.CD_EMP,
		F.CD_FILIAL,
		F.CD_FABRIC;
	--------------------------------------------------------------------------------------
	INSERT INTO EST_TOP_SHOW_EST_PROD_FABRIC_PRC_FILIAL(CD_EMP,CD_TOP_SHOW,CD_FILIAL,CD_FABRIC,
													DT_INI_REF,DT_FIM_REF,PERC_META,QTDE_META,CD_USU,DT_CAD,QTDE_VD_ANO,QTDE_VD_ULT)
	SELECT 
		P.CD_EMP,
		CD_TOP_SHOW,
		P.CD_FILIAL,
		P.CD_FABRIC,
		CASE WHEN ISNULL(A.QTDE,0) > ISNULL(U.QTDE,0) THEN
				P.DT_INI_ANO
			ELSE P.DT_INI_ULT END DT_INI_REF,

		CASE WHEN ISNULL(A.QTDE,0) > ISNULL(U.QTDE,0) THEN
				P.DT_FIM_ANO
			ELSE P.DT_FIM_ULT END DT_FIM_REF,

		P.PERC_CRESC,

		ROUND(CASE WHEN ISNULL(A.QTDE,0) > ISNULL(U.QTDE,0) THEN ISNULL(A.QTDE,0)
				ELSE  ISNULL(U.QTDE,0)END  * (1+(P.PERC_CRESC/100.00)),0) META,
		@CD_USU,
		GETDATE(),
		ISNULL(A.QTDE,0) QTDE_VD_ANO,
		ISNULL(U.QTDE,0) QTDE_VD_ULT
	FROM 
		#RS_TOP_FABRIC P
		LEFT JOIN #RS_TOP_FABRIC_ANO A ON 
		P.CD_EMP = A.CD_EMP AND
		P.CD_FABRIC = A.CD_FABRIC AND
		P.CD_FILIAL = A.CD_FILIAL
		LEFT JOIN #RS_TOP_FABRIC_ULT U ON 
		P.CD_EMP = U.CD_EMP AND
		P.CD_FABRIC = U.CD_FABRIC AND
		P.CD_FILIAL = U.CD_FILIAL;
	--DELETE FROM EST_TOP_SHOW_EST_PROD_FABRIC_PRC_FILIAL WHERE QTDE_META =0;
	DROP TABLE #RS_TOP_FABRIC
	DROP TABLE #RS_TOP_FABRIC_ANO
	DROP TABLE #RS_TOP_FABRIC_ULT
	
	UPDATE A
	SET QTD_VD=META
	FROM
		EST_TOP_SHOW_EST_PROD_FABRIC  A
		INNER JOIN (SELECT 
						CD_EMP,	
						CD_TOP_SHOW	,
						CD_FABRIC,	
						SUM(QTDE_META) META
					FROM 
						EST_TOP_SHOW_EST_PROD_FABRIC_PRC_FILIAL
					WHERE
						CD_TOP_SHOW=@CD_TOP_SHOW
					GROUP BY 
					CD_EMP,	
						CD_TOP_SHOW	,
						CD_FABRIC) CONS ON
		A.CD_EMP = CONS.CD_EMP AND
		A.CD_TOP_SHOW = CONS.CD_TOP_SHOW	 AND
		A.CD_FABRIC =CONS.CD_FABRIC	
	WHERE
		A.CD_TOP_SHOW=@CD_TOP_SHOW
		AND A.CD_EMP=@CD_EMP

/*********************************************************************************************************************/ 
	PRINT 'Carregando as familias do Top Show - Time ' + convert(varchar,getdate(),108)
/*********************************************************************************************************************/
-- Familias
/*********************************************************************************************************************/

	SELECT 
		S.CD_EMP,
		S.CD_TOP_SHOW,	
		s.DT_INI_TOP_SHOW,
		s.DT_FIM_TOP_SHOW,
		DATEADD(YEAR,-1,s.DT_INI_TOP_SHOW) DT_INI_ANO,
		DATEADD(YEAR,-1,s.DT_FIM_TOP_SHOW) DT_FIM_ANO,
		DATEADD(DAY,-120,s.DT_INI_TOP_SHOW) DT_INI_ULT,
		DATEADD(DAY,-120,s.DT_FIM_TOP_SHOW)	DT_FIM_ULT,  
		F.CD_FILIAL,
		P.CD_ARV_MERC_FAMILIA, 
		P.PERC_CRESC
		INTO #RS_TOP_FAM
	FROM
		EST_TOP_SHOW S
		INNER JOIN EST_TOP_SHOW_PRC_FILIAL F ON 
		S.CD_EMP	  = F.CD_EMP AND
		S.CD_TOP_SHOW = F.CD_TOP_SHOW
		INNER JOIN EST_TOP_SHOW_EST_ARV_MERC_FAMILIA P ON 
		S.CD_EMP	  = P.CD_EMP AND
		S.CD_TOP_SHOW = P.CD_TOP_SHOW 
	WHERE 
		S.CD_EMP=@CD_EMP 
		AND S.CD_TOP_SHOW =@CD_TOP_SHOW
		AND s.DT_INI_TOP_SHOW <= @HOJE		
		AND s.DT_FIM_TOP_SHOW >= @HOJE;

	/*
	DELETE FROM B FROM
		EST_TOP_SHOW_EST_ARV_MERC_FAMILIA_PRC_FILIAL A
		INNER JOIN #RS_TOP_FAM B ON 
		A.CD_EMP = B.CD_EMP AND
		A.CD_FILIAL=B.CD_FILIAL AND
		A.CD_ARV_MERC_FAMILIA=B.CD_ARV_MERC_FAMILIA
	WHERE
		A.CD_TOP_SHOW=@CD_TOP_SHOW
	*/
		
	DELETE FROM EST_TOP_SHOW_EST_ARV_MERC_FAMILIA_PRC_FILIAL WHERE CD_EMP=@CD_EMP AND CD_TOP_SHOW=@CD_TOP_SHOW
	--------------------------------------------------------------------------------------
	SELECT  
		F.CD_EMP,
		F.CD_FILIAL,
		F.CD_ARV_MERC_FAMILIA,
		SUM(I.QT_IT) QTDE
		INTO #RS_TOP_FAM_ANO
	FROM
		V_PDV_VD_IT I
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA  P ON
		I.CD_EMP	 = P.CD_EMP AND
		I.CD_PROD    = P.CD_PROD
		INNER JOIN #RS_TOP_FAM F ON
		I.CD_EMP	 = F.CD_EMP AND
		I.CD_FILIAL  = F.CD_FILIAL AND
		F.CD_ARV_MERC_FAMILIA    = P.CD_ARV_MERC_FAMILIA
		AND I.DT_VD BETWEEN F.DT_INI_ANO AND F.DT_FIM_ANO 
	WHERE
		I.CD_EMP = @CD_EMP
	GROUP BY 		
		F.CD_EMP,
		F.CD_FILIAL,
		F.CD_ARV_MERC_FAMILIA;

	SELECT  
		F.CD_EMP,
		F.CD_FILIAL,
		F.CD_ARV_MERC_FAMILIA,
		SUM(I.QT_IT) QTDE
		INTO #RS_TOP_FAM_ULT
	FROM
		V_PDV_VD_IT I
		INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA  P ON
		I.CD_EMP	 = P.CD_EMP AND
		I.CD_PROD    = P.CD_PROD
		INNER JOIN #RS_TOP_FAM F ON
		I.CD_EMP	 = F.CD_EMP AND
		I.CD_FILIAL  = F.CD_FILIAL AND
		F.CD_ARV_MERC_FAMILIA    = P.CD_ARV_MERC_FAMILIA
		AND I.DT_VD BETWEEN F.DT_INI_ULT AND F.DT_FIM_ULT 
	WHERE
		I.CD_EMP = @CD_EMP
	GROUP BY 		
		F.CD_EMP,
		F.CD_FILIAL,
		F.CD_ARV_MERC_FAMILIA;

	--------------------------------------------------------------------------------------
	INSERT INTO EST_TOP_SHOW_EST_ARV_MERC_FAMILIA_PRC_FILIAL(CD_EMP,CD_TOP_SHOW,CD_FILIAL,CD_ARV_MERC_FAMILIA,
													DT_INI_REF,DT_FIM_REF,PERC_META,QTDE_META,CD_USU,DT_CAD,QTDE_VD_ANO,QTDE_VD_ULT)
	SELECT 
		P.CD_EMP,
		CD_TOP_SHOW,
		P.CD_FILIAL,
		P.CD_ARV_MERC_FAMILIA,
		CASE WHEN ISNULL(A.QTDE,0) > ISNULL(U.QTDE,0) THEN
				P.DT_INI_ANO
			ELSE P.DT_INI_ULT END DT_INI_REF,

		CASE WHEN ISNULL(A.QTDE,0) > ISNULL(U.QTDE,0) THEN
				P.DT_FIM_ANO
			ELSE P.DT_FIM_ULT END DT_FIM_REF,

		P.PERC_CRESC,

		ROUND(CASE WHEN ISNULL(A.QTDE,0) > ISNULL(U.QTDE,0) THEN ISNULL(A.QTDE,0)
				ELSE  ISNULL(U.QTDE,0)END  * (1+(P.PERC_CRESC/100.00)),0) META,
		@CD_USU,
		GETDATE(),
		ISNULL(A.QTDE,0) QTDE_VD_ANO,
		ISNULL(U.QTDE,0) QTDE_VD_ULT

	FROM 
		#RS_TOP_FAM P
		LEFT JOIN #RS_TOP_FAM_ANO A ON 
		P.CD_EMP = A.CD_EMP AND
		P.CD_ARV_MERC_FAMILIA = A.CD_ARV_MERC_FAMILIA AND
		P.CD_FILIAL = A.CD_FILIAL
		LEFT JOIN #RS_TOP_FAM_ULT U ON 
		P.CD_EMP = U.CD_EMP AND
		P.CD_ARV_MERC_FAMILIA = U.CD_ARV_MERC_FAMILIA AND
		P.CD_FILIAL = U.CD_FILIAL;

	--DELETE FROM EST_TOP_SHOW_EST_ARV_MERC_FAMILIA_PRC_FILIAL WHERE QTDE_META =0;
	DROP TABLE #RS_TOP_FAM;
	DROP TABLE #RS_TOP_FAM_ANO;
	DROP TABLE #RS_TOP_FAM_ULT;

	UPDATE A
	SET QTD_VD=META
	FROM
		EST_TOP_SHOW_EST_ARV_MERC_FAMILIA  A
		INNER JOIN (SELECT 
						CD_EMP,	
						CD_TOP_SHOW	,
						CD_ARV_MERC_FAMILIA,	
						SUM(QTDE_META) META
					FROM 
						EST_TOP_SHOW_EST_ARV_MERC_FAMILIA_PRC_FILIAL
					WHERE
						CD_TOP_SHOW=@CD_TOP_SHOW
					GROUP BY 
					CD_EMP,	
						CD_TOP_SHOW	,
						CD_ARV_MERC_FAMILIA) CONS ON
		A.CD_EMP			= CONS.CD_EMP AND
		A.CD_TOP_SHOW		  = CONS.CD_TOP_SHOW	 AND
		A.CD_ARV_MERC_FAMILIA =CONS.CD_ARV_MERC_FAMILIA	
	WHERE
		A.CD_TOP_SHOW=@CD_TOP_SHOW
		AND A.CD_EMP=@CD_EMP;

/*********************************************************************************************************************/